#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>


using namespace std;

struct rat
{
	int x, y;
	rat(int a, int b)
	{
		int t = __gcd(a, b);
		x = a / t;
		y = b / t;
	}
};

ostream& operator << (ostream& out, rat a)
{
	if (a.y == 1) {
		return out << a.x;
	} else {
		return out << a.x << "/" << a.y;
	}
}

rat operator + (rat a, rat b)
{
	return rat(a.x * b.y + b.x * a.y, a.y * b.y);
}

pair<rat, int> get(string s)
{
	if (s.length() <= 5)
	{
		if (s[0] == 'n')
			return make_pair(rat(0, 1), 1);
		else
			return make_pair(rat(90, 1), 1);
	} else {
		if (s[0] == 'n')
		{
			pair<rat, int> t = get(s.substr(5, s.length() - 5));
			rat a = t.first;
			int n = t.second;
			return make_pair(a + rat(-90, 1 << n), n + 1);
		} else {
			pair<rat, int> t = get(s.substr(4, s.length() - 4));
			rat a = t.first;
			int n = t.second;
			return make_pair( a + rat(90, 1 << n), n + 1); 
		}
	}
}

int main()
{
	//ios_base::sync_with_stdio(false);
	//freopen(".in", "r", stdin);
	//freopen(".out", "w", stdout);
	string s;
	
	while ( cin >> s)
	{
		if (s == "#")
			break;
		cout << get(s).first << endl;
	}
	
	return 0;
}